turtles-own [dist           ;; distance from 'goal' in current state
             old-dist       ;; distance from 'goal' in last state
             intx           ;; x-intersection (for parabola)
             inty           ;; y-intersection (for parabola)
             diff           ;; modified distance to x and y intercepts in current state
             old-diff]      ;; modified distance to x and y intercepts in last state

globals [cx                 ;; x-cor of the circle's center
         cy                 ;; y-cor of the circle's center
         f0x                ;; x-cor of focus 0 (for ellipse)
         f0y                ;; y-cor of focus 0 (for ellipse)
         f1x                ;; x-cor of focus 1 (for ellipse)
         f1y                ;; y-cor of focus 1 (for ellipse)
         state]             ;; flag to alternate between different values with WatchMouse


to setup
  ca
  set cx 0
  set cy 0
  set f0x 0
  set f0y 0
  set f1x 0
  set f1y 0
  set state 0
  set (pcolor-of patch 0 0) white
  crt num-turtles 
  ask turtles [
    set color green
    setxy random-float screen-size-x
          random-float screen-size-y
  ]
end

to change-focus
end

to watchmouse  ;; turns focus white where mouse is clicked
  if mouse-down? [
    ask patches [ set pcolor black ]
    set cx (round mouse-xcor)
    set cy (round mouse-ycor)
    set (pcolor-of patch-at cx cy) white
  ]
end

to watchmouse2  ;; turns two foci white
  if mouse-down? [
    let mousex (round mouse-xcor)
    let mousey (round mouse-ycor)
    if pcolor-of patch-at mousex mousey = white [ stop ]
    ask patches [ set pcolor black ]
    ifelse (state = 0)
      [set f0x (round mouse-xcor)
       set f0y (round mouse-ycor)
       set state 1]
      [set f1x (round mouse-xcor)
       set f1y (round mouse-ycor)
       set state 0]
    set (pcolor-of patch-at f0x f0y) white
    set (pcolor-of patch-at f1x f1y) white
  ]
end

to go
  ifelse mouse-down? [
    ifelse not second-focus?
      [watchmouse]
      [watchmouse2]
  ]
  [ ask turtles [ move-turtles ] ]
end

to move-turtles ; turtle procedure
  set old-dist dist
  ifelse not second-focus?
    [set dist (distancexy-nowrap cx cy)]
    [set dist ((distancexy-nowrap f0x f0y) + (distancexy-nowrap f1x f1y)) / 2]
  ifelse ((int dist) = constant)
   [stop]
   [ifelse ((dist < old-dist) and (dist > constant))
     [fd 1]
     [ifelse ((dist > old-dist) and (dist < constant))
       [fd 1]
       [rt random-float 360 fd 1]]]
end 


; *** NetLogo Model Copyright Notice ***
;
; This model was created as part of the project: CONNECTED MATHEMATICS:
; MAKING SENSE OF COMPLEX PHENOMENA THROUGH BUILDING OBJECT-BASED PARALLEL
; MODELS (OBPML).  The project gratefully acknowledges the support of the
; National Science Foundation (Applications of Advanced Technologies
; Program) -- grant numbers RED #9552950 and REC #9632612.
;
; Copyright 1998 by Uri Wilensky. All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; This model was converted to NetLogo as part of the project:
; PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING IN
; CLASSROOMS.  The project gratefully acknowledges the support of the
; National Science Foundation (REPP program) -- grant number REC #9814682.
; Converted from StarLogoT to NetLogo, 2001.  Updated 2002.
;
; To refer to this model in academic publications, please use:
; Wilensky, U. (1998).  NetLogo Conic Sections model.
; http://ccl.northwestern.edu/netlogo/models/ConicSections.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 1998 by Uri Wilensky.  All rights reserved.  See
; http://ccl.northwestern.edu/netlogo/models/ConicSections
; for terms of use.
;
; *** End of NetLogo Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
286
10
606
351
15
15
10.0
1
10
1
1
1
0

CC-WINDOW
5
365
615
460
Command Center

SLIDER
6
105
272
138
num-turtles
num-turtles
1
300
200
1
1
NIL

SLIDER
12
154
272
187
constant
constant
0
20
9
1
1
NIL

BUTTON
72
48
133
82
NIL
setup
NIL
1
T
OBSERVER
T
NIL

SWITCH
79
209
232
242
second-focus?
second-focus?
0
1
-1000

BUTTON
144
48
225
82
NIL
go
T
1
T
OBSERVER
T
NIL

TEXTBOX
75
290
222
341
To set a focus, click the mouse on a patch.

@#$#@#$#@
WHAT IS IT?
-----------
The model displays two basic conic sections: circles and ellipses. The figures are generated behaviorally as opposed to algebraically -- the turtles attempt to behave like points on the specified shape.

A circle is the set of all points at a certain distance (radius) from a central point.  An ellipse is the set of points such that the sum of the distances to two points is constant.  These two points are called foci. The CONSTANT slider corresponds to the radius for circles and to the sum of distances to the foci for each turtle.

As an illustration of this, imagine a string loosely looped around two nails, each representing a focus.  If you pull the string tight with a pencil point and move the pencil point around the foci, you will draw an ellipse.

The ancient Greeks discovered that each conic section can be found by taking a cross section of one or two cones with their points pointing toward each other.  A circle results from taking a slice that is perpendicular to the axis, while an ellipse results from taking a slice of one cone that is not perpendicular to the axis. Similiarly, a parabola results from a cross section that passes through one cone in a vertical fashion, such that the plane of the cut is parallel to one face. A hyperbola results from a vertical section that passes through both cones.

The turtles use feedback to make decisions about how they behave. They set out in random directions, and then they receive information as to whether or not they are getting closer to where they want to be. If they are getting closer, they continue moving forward in the direction they are going. If they are moving farther away, they set out in a new random direction. This process is akin to the children's game of "Hot & Cold", in which players are told whether they are getting "hotter" or "colder" in relation to a hidden goal.

HOW TO USE IT
-------------
*Circles:
-Select the number of turtles with the TURTLES slider.
-Press SETUP.
-Make sure the SECOND-FOCUS switch is set to OFF.
-Press the MOVE-TURTLES button. Adjust the radius of the circle with the CONSTANT slider. The turtles will automatically correct themselves as you change both CONSTANT and the location of the center. You can change the circle's center by clicking on a new point.

*Ellipses:
-Select the number of turtles with the TURTLES slider.
-Press SETUP.
-Make sure the SECOND-FOCUS switch is set to ON.
-Press the MOVE-TURTLES button. As for a circle, the size of the ellipse can be modified with CONSTANT, and new foci can be picked by clicking the mouse.

THINGS TO NOTICE
----------------
When forming a circle, turtles try to attain a distance of CONSTANT (a value determined by the user with a slider) from a center that the user determines by pointing and clicking (as explained above).

When forming an ellipse, turtles try to attain a combined distance of 2 * CONSTANT from the two foci, again determined by the user's points and clicks.  If the foci are too far apart, there be no way to satisfy this condition.  What do the turtles do then?

THINGS TO TRY
-------------
You may be able to get a better feeling for the turtles' behavior if only a few turtles are on-screen at one time. Try setting num-turtles to a smallvalue (like 16 or 1) and watching the turtles.

Both of these conic sections can be observed by shining a flashlight at a cone and looking at its shadow.  Can you figure out at what angles the cone must be held?

EXTENDING THE MODEL
-------------------
If you have access to StarLogoT (NetLogo's Macintosh-only predecessor), look at the StarLogoT model 'emergent-circle'. Watch how the turtles react with each other- something that is missing from 'Conic Sections'. Implement this emergent behavior for one or both of the conics in this project.

NETLOGO FEATURES
-----------------
Like more traditional programming languages (e.g. C++), NetLogo can have functions that report a value to the caller. The function used here is called 'location'-- it has two inputs, an x-coordinate and a y-coordinate. In this model, it reports true or false.  It is set up using "to-report" and "report".

CREDITS AND REFERENCES
----------------------
To refer to this model in academic publications, please use: Wilensky, U. (1998).  NetLogo Conic Sections model. http://ccl.northwestern.edu/netlogo/models/ConicSections. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

In other publications, please use: Copyright 1998 by Uri Wilensky.  All rights reserved.  See http://ccl.northwestern.edu/netlogo/models/ConicSections for terms of use.
@#$#@#$#@
default
true
0
Polygon -7566196 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7566196 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7566196 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7566196 true true 150 285 285 225 285 75 150 135
Polygon -7566196 true true 150 135 15 75 150 15 285 75
Polygon -7566196 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7566196 true true 96 182 108
Circle -7566196 true true 110 127 80
Circle -7566196 true true 110 75 80
Line -7566196 true 150 100 80 30
Line -7566196 true 150 100 220 30

butterfly
true
0
Polygon -7566196 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7566196 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7566196 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7566196 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7566196 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7566196 true true 47 195 58
Circle -7566196 true true 195 195 58

circle
false
0
Circle -7566196 true true 30 30 240

circle 2
false
0
Circle -7566196 true true 16 16 270
Circle -16777216 true false 46 46 210

cow
false
0
Polygon -7566196 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7566196 true true 73 210 86 251 62 249 48 208
Polygon -7566196 true true 25 114 16 195 9 204 23 213 25 200 39 123

face happy
false
0
Circle -7566196 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7566196 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7566196 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7566196 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7566196 true true 60 15 75 300
Polygon -7566196 true true 90 150 270 90 90 30
Line -7566196 true 75 135 90 135
Line -7566196 true 75 45 90 45

flower
false
0
Polygon -11352576 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7566196 true true 85 132 38
Circle -7566196 true true 130 147 38
Circle -7566196 true true 192 85 38
Circle -7566196 true true 85 40 38
Circle -7566196 true true 177 40 38
Circle -7566196 true true 177 132 38
Circle -7566196 true true 70 85 38
Circle -7566196 true true 130 25 38
Circle -7566196 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -11352576 true false 189 233 219 188 249 173 279 188 234 218
Polygon -11352576 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7566196 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7566196 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7566196 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7566196 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7566196 true 150 0 150 300

pentagon
false
0
Polygon -7566196 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7566196 true true 110 5 80
Polygon -7566196 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7566196 true true 127 79 172 94
Polygon -7566196 true true 195 90 240 150 225 180 165 105
Polygon -7566196 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7566196 true true 135 90 165 300
Polygon -7566196 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7566196 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7566196 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7566196 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7566196 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7566196 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7566196 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7566196 true true 30 30 270 270

square 2
false
0
Rectangle -7566196 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7566196 true true 60 270 150 0 240 270 15 105 285 105
Polygon -7566196 true true 75 120 105 210 195 210 225 120 150 75

target
false
0
Circle -7566196 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7566196 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7566196 true true 120 120 60

tree
false
0
Circle -7566196 true true 118 3 94
Rectangle -6524078 true false 120 195 180 300
Circle -7566196 true true 65 21 108
Circle -7566196 true true 116 41 127
Circle -7566196 true true 45 90 120
Circle -7566196 true true 104 74 152

triangle
false
0
Polygon -7566196 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7566196 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7566196 true true 4 45 195 187
Polygon -7566196 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7566196 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7566196 false true 24 174 42
Circle -7566196 false true 144 174 42
Circle -7566196 false true 234 174 42

turtle
true
0
Polygon -11352576 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -11352576 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -11352576 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -11352576 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -11352576 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7566196 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7566196 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7566196 true 150 285 150 15
Line -7566196 true 15 150 285 150
Circle -7566196 true true 120 120 60
Line -7566196 true 216 40 79 269
Line -7566196 true 40 84 269 221
Line -7566196 true 40 216 269 79
Line -7566196 true 84 40 221 269

x
false
0
Polygon -7566196 true true 270 75 225 30 30 225 75 270
Polygon -7566196 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 2.1beta4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
